#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.SuperDom;
using NinjaTrader.Gui.Tools;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript;
using NinjaTrader.Core.FloatingPoint;
using NinjaTrader.NinjaScript.DrawingTools;
using NinjaTrader.NinjaScript.Indicators.Porschay;
#endregion

//This namespace holds Indicators in this folder and is required. Do not change it. 
namespace NinjaTrader.NinjaScript.Indicators.Porschay
{
	public enum PriscillianManipulatorX1MTFTypeEnum
	{
		Second,
		Minute,
		Range,
		PorschayRXBars,
		TXRBars,
		QAI,
	}
	
	public class PriscillianManipulatorX1MTF : Indicator
	{
		private ATR atr;
		public Series<double> lineColor;
		private NinjaTrader.NinjaScript.Indicators.Porschay.PriscillianManipulatorX1 manipulator;
		
		protected override void OnStateChange()
		{
			if (State == State.SetDefaults)
			{
				Description									= @"Enter the description for your new custom Indicator here.";
				Name										= "Priscillian - Manipulator X1 MTF";
				Calculate									= Calculate.OnBarClose;
				IsOverlay									= true;
				DisplayInDataBox							= true;
				DrawOnPricePanel							= true;
				DrawHorizontalGridLines						= true;
				DrawVerticalGridLines						= true;
				PaintPriceMarkers							= true;
				ScaleJustification							= NinjaTrader.Gui.Chart.ScaleJustification.Right;
				//Disable this property if your indicator requires custom values that cumulate with each new market data event. 
				//See Help Guide for additional information.
				IsSuspendedWhileInactive					= true;
				
				barsType = PriscillianManipulatorX1MTFTypeEnum.Minute;
				value = 15;
				value2 = 15;
				baseBarsPeriodValue = 15;
				
				Period					= 12;
				Multiplier					= 3;
				
				BullBrush						= Brushes.Lime;
				BearBrush						= Brushes.Red;
				
				AddPlot(Brushes.Orange, "TrailingStop");
			}
			else if (State == State.Configure)
			{
				switch (barsType) {
					case PriscillianManipulatorX1MTFTypeEnum.TXRBars:
						AddDataSeries(Data.BarsPeriodType.Tick, value);
						break;
					
					case PriscillianManipulatorX1MTFTypeEnum.Second:
						AddDataSeries(Data.BarsPeriodType.Second, value);
						break;
					
					case PriscillianManipulatorX1MTFTypeEnum.Minute:
						AddDataSeries(Data.BarsPeriodType.Minute, value);
						break;
						
					case PriscillianManipulatorX1MTFTypeEnum.Range:
						AddDataSeries(Data.BarsPeriodType.Range, value);
						break;
					
					case PriscillianManipulatorX1MTFTypeEnum.PorschayRXBars:
						AddDataSeries(new BarsPeriod { BarsPeriodType = (BarsPeriodType)2019, Value = value, Value2 = value2 });
						break;
					
					case PriscillianManipulatorX1MTFTypeEnum.QAI:
						AddDataSeries(new BarsPeriod { BarsPeriodType = (BarsPeriodType)230507, BaseBarsPeriodValue = baseBarsPeriodValue, Value = value, Value2 = value2 });
						break;
				}
			}
			else if (State == State.DataLoaded)
			{
				lineColor = new Series<double>(this);
				manipulator = PriscillianManipulatorX1(BarsArray[1], Period, Multiplier);
			}
		}

		protected override void OnBarUpdate()
		{	
			if (CurrentBar < Period)
				return;
			
			if (BarsInProgress != 0)
        		return;
			
			if (manipulator.lineColor[0] == 0) {
				return;
			}

			double manipulatorLineColor = manipulator.lineColor[0];
			
			lineColor[0] = manipulatorLineColor;
			TrailingStop[0] = manipulator.TrailingStop[0];
			
			PlotBrushes[0][0] = manipulatorLineColor == 1 ? BullBrush : BearBrush;
		}

		#region Properties
		[NinjaScriptProperty]
		[Display(Name="Bars Type", Order=1, GroupName="Parameters")]
		public PriscillianManipulatorX1MTFTypeEnum barsType { get; set; }
		
		[NinjaScriptProperty]
		[Range(1, int.MaxValue)]
		[Display(Name="Value", Order=2, GroupName="Parameters")]
		public int value
		{ get; set; }
		
		[NinjaScriptProperty]
		[Range(1, int.MaxValue)]
		[Display(Name="Value2", Order=3, GroupName="Parameters")]
		public int value2
		{ get; set; }
		
		[NinjaScriptProperty]
		[Range(1, int.MaxValue)]
		[Display(Name="Q.AI (Open Offset)", Order=4, GroupName="Parameters")]
		public int baseBarsPeriodValue
		{ get; set; }
		//
		
		[NinjaScriptProperty]
		[Range(1, int.MaxValue)]
		[Display(Name="Period", Order=1, GroupName="Manipulator X1")]
		public int Period
		{ get; set; }

		[NinjaScriptProperty]
		[Range(1, int.MaxValue)]
		[Display(Name="Multiplier", Order=2, GroupName="Manipulator X1")]
		public int Multiplier
		{ get; set; }
		
		[XmlIgnore()]
		[Display(Name = "Bull Color", GroupName="Colors", Order=1)]
		public Brush BullBrush
		{ get; set; }

		[Browsable(false)]
		public string BullBrushSerialize
		{
			get { return Serialize.BrushToString(BullBrush); }
   			set { BullBrush = Serialize.StringToBrush(value); }
		}
		
		[XmlIgnore()]
		[Display(Name = "Bear Color", GroupName="Colors", Order=2)]
		public Brush BearBrush
		{ get; set; }

		[Browsable(false)]
		public string BearBrushSerialize
		{
			get { return Serialize.BrushToString(BearBrush); }
   			set { BearBrush = Serialize.StringToBrush(value); }
		}

		[Browsable(false)]
		[XmlIgnore]
		public Series<double> TrailingStop
		{
			get { return Values[0]; }
		}
		#endregion

	}
}

#region NinjaScript generated code. Neither change nor remove.

namespace NinjaTrader.NinjaScript.Indicators
{
	public partial class Indicator : NinjaTrader.Gui.NinjaScript.IndicatorRenderBase
	{
		private Porschay.PriscillianManipulatorX1MTF[] cachePriscillianManipulatorX1MTF;
		public Porschay.PriscillianManipulatorX1MTF PriscillianManipulatorX1MTF(PriscillianManipulatorX1MTFTypeEnum barsType, int value, int value2, int baseBarsPeriodValue, int period, int multiplier)
		{
			return PriscillianManipulatorX1MTF(Input, barsType, value, value2, baseBarsPeriodValue, period, multiplier);
		}

		public Porschay.PriscillianManipulatorX1MTF PriscillianManipulatorX1MTF(ISeries<double> input, PriscillianManipulatorX1MTFTypeEnum barsType, int value, int value2, int baseBarsPeriodValue, int period, int multiplier)
		{
			if (cachePriscillianManipulatorX1MTF != null)
				for (int idx = 0; idx < cachePriscillianManipulatorX1MTF.Length; idx++)
					if (cachePriscillianManipulatorX1MTF[idx] != null && cachePriscillianManipulatorX1MTF[idx].barsType == barsType && cachePriscillianManipulatorX1MTF[idx].value == value && cachePriscillianManipulatorX1MTF[idx].value2 == value2 && cachePriscillianManipulatorX1MTF[idx].baseBarsPeriodValue == baseBarsPeriodValue && cachePriscillianManipulatorX1MTF[idx].Period == period && cachePriscillianManipulatorX1MTF[idx].Multiplier == multiplier && cachePriscillianManipulatorX1MTF[idx].EqualsInput(input))
						return cachePriscillianManipulatorX1MTF[idx];
			return CacheIndicator<Porschay.PriscillianManipulatorX1MTF>(new Porschay.PriscillianManipulatorX1MTF(){ barsType = barsType, value = value, value2 = value2, baseBarsPeriodValue = baseBarsPeriodValue, Period = period, Multiplier = multiplier }, input, ref cachePriscillianManipulatorX1MTF);
		}
	}
}

namespace NinjaTrader.NinjaScript.MarketAnalyzerColumns
{
	public partial class MarketAnalyzerColumn : MarketAnalyzerColumnBase
	{
		public Indicators.Porschay.PriscillianManipulatorX1MTF PriscillianManipulatorX1MTF(PriscillianManipulatorX1MTFTypeEnum barsType, int value, int value2, int baseBarsPeriodValue, int period, int multiplier)
		{
			return indicator.PriscillianManipulatorX1MTF(Input, barsType, value, value2, baseBarsPeriodValue, period, multiplier);
		}

		public Indicators.Porschay.PriscillianManipulatorX1MTF PriscillianManipulatorX1MTF(ISeries<double> input , PriscillianManipulatorX1MTFTypeEnum barsType, int value, int value2, int baseBarsPeriodValue, int period, int multiplier)
		{
			return indicator.PriscillianManipulatorX1MTF(input, barsType, value, value2, baseBarsPeriodValue, period, multiplier);
		}
	}
}

namespace NinjaTrader.NinjaScript.Strategies
{
	public partial class Strategy : NinjaTrader.Gui.NinjaScript.StrategyRenderBase
	{
		public Indicators.Porschay.PriscillianManipulatorX1MTF PriscillianManipulatorX1MTF(PriscillianManipulatorX1MTFTypeEnum barsType, int value, int value2, int baseBarsPeriodValue, int period, int multiplier)
		{
			return indicator.PriscillianManipulatorX1MTF(Input, barsType, value, value2, baseBarsPeriodValue, period, multiplier);
		}

		public Indicators.Porschay.PriscillianManipulatorX1MTF PriscillianManipulatorX1MTF(ISeries<double> input , PriscillianManipulatorX1MTFTypeEnum barsType, int value, int value2, int baseBarsPeriodValue, int period, int multiplier)
		{
			return indicator.PriscillianManipulatorX1MTF(input, barsType, value, value2, baseBarsPeriodValue, period, multiplier);
		}
	}
}

#endregion
